//
// 20.02.2025 www.satyria.de
//
// base.h
//

#ifndef _base_h
#define _base_h

#define PeripheralEntry()	((void) 0)	// ignored here
#define PeripheralExit()	((void) 0)


#define RPI_BASE 0xFE000000

// General Purpose I/O (GPIO)                 
#define GPIO_BASE RPI_BASE + 0x200000               
#define GPIO_GPFSEL0                    GPIO_BASE + 0x00 // GPIO Function Select 0        
#define GPIO_GPFSEL1                    GPIO_BASE + 0x04 // GPIO Function Select 1        
#define GPIO_GPFSEL2                    GPIO_BASE + 0x08 // GPIO Function Select 2        
#define GPIO_GPFSEL3                    GPIO_BASE + 0x0c // GPIO Function Select 3        
#define GPIO_GPFSEL4                    GPIO_BASE + 0x10 // GPIO Function Select 4        
#define GPIO_GPFSEL5                    GPIO_BASE + 0x14 // GPIO Function Select 5        
#define GPIO_GPSET0                     GPIO_BASE + 0x1c // GPIO Pin Output Set 0       
#define GPIO_GPSET1                     GPIO_BASE + 0x20 // GPIO Pin Output Set 1       
#define GPIO_GPCLR0                     GPIO_BASE + 0x28 // GPIO Pin Output Clear 0       
#define GPIO_GPCLR1                     GPIO_BASE + 0x2c // GPIO Pin Output Clear 1       
#define GPIO_GPLEV0                     GPIO_BASE + 0x34 // GPIO Pin Level 0        
#define GPIO_GPLEV1                     GPIO_BASE + 0x38 // GPIO Pin Level 1        
#define GPIO_GPEDS0                     GPIO_BASE + 0x40 // GPIO Pin Event Detect Status 0      
#define GPIO_GPEDS1                     GPIO_BASE + 0x44 // GPIO Pin Event Detect Status 1      
#define GPIO_GPREN0                     GPIO_BASE + 0x4c // GPIO Pin Rising Edge Detect Enable 0     
#define GPIO_GPREN1                     GPIO_BASE + 0x50 // GPIO Pin Rising Edge Detect Enable 1     
#define GPIO_GPFEN0                     GPIO_BASE + 0x58 // GPIO Pin Falling Edge Detect Enable 0     
#define GPIO_GPFEN1                     GPIO_BASE + 0x5c // GPIO Pin Falling Edge Detect Enable 1     
#define GPIO_GPHEN0                     GPIO_BASE + 0x64 // GPIO Pin High Detect Enable 0      
#define GPIO_GPHEN1                     GPIO_BASE + 0x68 // GPIO Pin High Detect Enable 1      
#define GPIO_GPLEN0                     GPIO_BASE + 0x70 // GPIO Pin Low Detect Enable 0      
#define GPIO_GPLEN1                     GPIO_BASE + 0x74 // GPIO Pin Low Detect Enable 1      
#define GPIO_GPAREN0                    GPIO_BASE + 0x7c // GPIO Pin Async. Rising Edge Detect 0     
#define GPIO_GPAREN1                    GPIO_BASE + 0x80 // GPIO Pin Async. Rising Edge Detect 1     
#define GPIO_GPAFEN0                    GPIO_BASE + 0x88 // GPIO Pin Async. Falling Edge Detect 0     
#define GPIO_GPAFEN1                    GPIO_BASE + 0x8c // GPIO Pin Async. Falling Edge Detect 1     
#define GPIO_GPIO_PUP_PDN_CNTRL_REG0    GPIO_BASE + 0xe4 // GPIO Pull-up / Pull-down Register 0      
#define GPIO_GPIO_PUP_PDN_CNTRL_REG1    GPIO_BASE + 0xe8 // GPIO Pull-up / Pull-down Register 1      
#define GPIO_GPIO_PUP_PDN_CNTRL_REG2    GPIO_BASE + 0xec // GPIO Pull-up / Pull-down Register 2      
#define GPIO_GPIO_PUP_PDN_CNTRL_REG3    GPIO_BASE + 0xf0 // GPIO Pull-up / Pull-down Register 3      
// Information from BCM2835 ARM Peropherals                 
#define GPIO_GPPUD                      GPIO_BASE + 0x94 // GPIO Pin Pull-up/down Enable        
#define GPIO_GPPUDCLK0                  GPIO_BASE + 0x98 // GPIO Pin Pull-up/down Enable Clock 0      
#define GPIO_GPPUDCLK1                  GPIO_BASE + 0x9c // GPIO Pin Pull-up/down Enable Clock 1      

//
// Mailbox
//
#define MAILBOX_BASE RPI_BASE + 0xB880 
#define MAILBOX0_READ       MAILBOX_BASE + 0x00
#define MAILBOX0_STATUS     MAILBOX_BASE + 0x18
#define MAILBOX_STATUS_EMPTY    0x40000000
#define MAILBOX1_WRITE      MAILBOX_BASE + 0x20
#define MAILBOX1_STATUS     MAILBOX_BASE + 0x38
#define MAILBOX_STATUS_FULL 0x80000000

#define MAIL_WRITE MAILBOX_BASE + 0x20
#define MAIL_TAG_WRITE MAIL_WRITE + 0x8

#define MAILBOX_CHANNEL_PM  0       // power management
#define MAILBOX_CHANNEL_FB  1       // frame buffer
#define BCM_MAILBOX_PROP_OUT    8       // property tags (ARM to VC)

#endif